using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class FRAGMENT_COLLECTIONDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public FRAGMENT_COLLECTIONDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public FRAGMENT_COLLECTION GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_COLLECTION_ID)
		{
			FRAGMENT_COLLECTION objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FRAGMENT_COLLECTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_COLLECTION_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<FRAGMENT_COLLECTION> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<FRAGMENT_COLLECTION> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_FRAGMENT_COLLECTION_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, FRAGMENT_COLLECTION objSave)
		{
			Int32? objReturn = objSave.FRAGMENT_COLLECTION_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FRAGMENT_COLLECTION_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BODY_LOCATION_DSCR, DateTime.Now, objSave.CREATEDBY, ref objReturn, objSave.FRAGMENT_DSCR, objSave.FRAGMENT_REFERENCE_NUMBER, objSave.FRAGMENTS_REMAINING_IND, objSave.FRAGMENTS_REMAINING_NUMBER, objSave.INJURY_DATE, objSave.INJURY_GEO_LOCATION_DSCR, objSave.LAB_RETURN_DATE, objSave.LAB_SEND_DATE, objSave.OTHER_REMOVAL_FACILITY_DSCR, objSave.OTHER_REMOVAL_PROVIDER_DSCR, objSave.PATIENT_ID, objSave.PROVIDER_COMMENTS, objSave.REMOVAL_DATE, objSave.SHIPMENT_TRACKING_NUMBER, objSave.STD_INSTITUTION_ID, objSave.STD_REGISTRY_ID, objSave.TISSUE_COMPARTMENT_DSCR, DateTime.Now, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 FRAGMENT_COLLECTION_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_FRAGMENT_COLLECTION_delete(CURRENT_USER, CURRENT_REGISTRY_ID, FRAGMENT_COLLECTION_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
